#include <stdio.h>
#include <string.h>
#include <stdbool.h>

bool validate_message(const char *alphabet, const char *message) {
    // Para cada caractere da mensagem, verifica se está no alfabeto
    for (int i = 0; message[i] != '\0'; i++) {
        bool found = false;
        for (int j = 0; alphabet[j] != '\0'; j++) {
            if (message[i] == alphabet[j]) {
                found = true;
                break;
            }
        }
        if (!found) {
            return false;
        }
    }
    return true;
}

int main() {
    while (1) {
        int k, n;

        // Entrada de k e n
        printf("Digite k e n (0 0 para sair): ");
        scanf("%d %d", &k, &n);
        getchar(); // Consumir o caractere de quebra de linha

        if (k == 0 && n == 0) {
            break;
        }

        // Entrada do alfabeto e mensagem
        char alphabet[101], message[101];
        printf("Digite o alfabeto permitido: ");
        fgets(alphabet, sizeof(alphabet), stdin);
        alphabet[strcspn(alphabet, "\n")] = '\0'; // Remove o '\n'

        printf("Digite a mensagem a ser verificada: ");
        fgets(message, sizeof(message), stdin);
        message[strcspn(message, "\n")] = '\0'; // Remove o '\n'

        // Validação
        if (validate_message(alphabet, message)) {
            printf("Sim\n");
        } else {
            printf("Não\n");
        }
    }

    return 0;
}
